
raw_data1 = readmatrix('47.7m1.txt');
raw_data2 = readmatrix('47.7m2.txt');
raw_data3 = readmatrix('47.7m3.txt');
raw_data4 = readmatrix('47.7m4.txt');
raw_data5 = readmatrix('47.7m5.txt');
signal_1 = (raw_data1(:,2) + raw_data2(:,2) + raw_data3(:,2) + raw_data4(:,2) + raw_data5(:,2))/5;

raw_data1 = readmatrix('8.9m1.txt');
raw_data2 = readmatrix('8.9m2.txt');
raw_data3 = readmatrix('8.9m3.txt');
raw_data4 = readmatrix('8.9m4.txt');
raw_data5 = readmatrix('8.9m5.txt');
signal_2 = (raw_data1(:,2) + raw_data2(:,2) + raw_data3(:,2) + raw_data4(:,2) + raw_data5(:,2))/5;

wavelength = raw_data1(:,1);
wavevector = 2*pi./(wavelength*1E-9);



tiledlayout(1,2)

x0=10;
y0=10;
width=800;
height=600;


%% Transmission plots

nexttile
hold on
box on
plot(wavelength,signal_1,'LineWidth',1.5);
plot(wavelength,signal_2,'LineWidth',1.5);
xlabel('Wavelength / nm')
ylabel('Signal / dB')
xlim([550 1250])
ylim([-90 -55])
% legend('47.7 m','33.8 m','21.5 m','8.9 m')
legend('47.7 m','8.9 m')
% title('Transmission')


set(gca,'XMinorTick','on','YMinorTick','on')
set(gca,'XMinorTick','on','YMinorTick','on')
set(gca,'FontSize',24)
set(gcf,'color','w')
set(gcf,'position',[x0,y0,width,height])
H=gca;
H.LineWidth=2;
% txt1 = '(a)';
% t1 = text(590,-59,txt1,'FontSize',28);

hold off

loss2 = (signal_2 - signal_1)/38.8;


%% Loss plot

nexttile
hold on
box on
plot(wavelength,loss2,'LineWidth',1.5,'Color',[0.4940 0.1840 0.5560])
xlabel('Wavelength / nm')
ylabel('Attenuation / dB per m')
xlim([550 1250])
ylim([0 1])
% legend('47.7 m to 8.9 m')
% title('Attenuation')
set(gca,'XMinorTick','on','YMinorTick','on')
set(gca,'XMinorTick','on','YMinorTick','on')
set(gca,'FontSize',24)
set(gcf,'color','w')
set(gcf,'position',[x0,y0,width,height])
H=gca;
H.LineWidth=2;

x = [660 860 860 660];
y = [0 0 1 1];
patch(x,y,'black','FaceAlpha',.3,'EdgeAlpha',.5)

x2 = [1110 1250 1250 1110];
y2 = [0 0 1 1];
patch(x2,y2,'black','FaceAlpha',.3,'EdgeAlpha',.5)
hold off



% txt2 = '(b)';
% t2 = text(590,0.875,txt2,'FontSize',28);
% hold on

%% 

plot(wavevector,signal_1,'LineWidth',1.5);
xlabel('Wavevector / m-1')
ylabel('Signal / dB')
ylim([-100 -55])
xlim([5.5E+6 7.5E+6])
legend('47.7 m')
% title('Transmission')
set(gca,'XMinorTick','on','YMinorTick','on')
set(gca,'FontSize',24)
set(gcf,'color','w')

set(gcf,'position',[x0,y0,width,height])
hold off

